% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Gaussian_Inference.r
\name{rGaussian}
\alias{rGaussian}
\title{Random generation for Gaussian distribution}
\usage{
rGaussian(n, mu, Sigma = NULL, A = NULL)
}
\arguments{
\item{n}{integer, number of samples.}

\item{mu}{numeric, mean vector.}

\item{Sigma}{matrix, covariance matrix, one of Sigma and A should be non-NULL.}

\item{A}{matrix, the Cholesky decomposition of Sigma, an upper triangular matrix, one of Sigma and A should be non-NULL.}
}
\value{
A matrix of n rows and length(mu) columns.
}
\description{
Generate random samples from a Gaussian distribution. For a random vector x, the density function of a (multivariate) Gaussian distribution is defined as:
   \deqn{sqrt(2 pi^p |Sigma|)^{-1} exp(-1/2 (x-mu )^T Sigma^{-1} (x-mu))}
where p is the dimension of x.
}
\examples{
\donttest{
x <- rGaussian(1000,mu = c(1,1),Sigma = matrix(c(1,0.5,0.5,3),2,2))
plot(x)
}
}
\seealso{
\code{\link{dGaussian}}
}
