% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Dirichlet_Process.r
\name{sufficientStatistics_Weighted.HDP2}
\alias{sufficientStatistics_Weighted.HDP2}
\title{Weighted sufficient statistics of a "HDP2" object}
\usage{
\method{sufficientStatistics_Weighted}{HDP2}(obj, x, w, ...)
}
\arguments{
\item{obj}{A "HDP2" object.}

\item{x}{Random samples of the "BasicBayesian" object.}

\item{w}{numeric, sample weights.}

\item{...}{Additional arguments to be passed to other inherited types.}
}
\value{
Return the sufficient statistics of the corresponding BasicBayesian type, see examples.
}
\description{
For following model structure:
     \deqn{G |eta \sim DP(eta,U)}
     \deqn{G_m|gamma,G \sim DP(gamma,G), m = 1:M}
     \deqn{pi_{mj}|G_m,alpha \sim DP(alpha,G_m), j = 1:J_m}
     \deqn{z|pi_{mj} \sim Categorical(pi_{mj})}
     \deqn{k|z,G_m \sim Categorical(G_m),\textrm{ if z is a sample from the base measure } G_{mj}}
     \deqn{u|k,G \sim Categorical(G),\textrm{ if k is a sample from the base measure G}}
     \deqn{theta_u|psi \sim H0(psi)}
     \deqn{x|theta_u,u \sim F(theta_u)}
where DP(eta,U) is a Dirichlet Process on positive integers, eta is the "concentration parameter", U is the "base measure" of this Dirichlet process, U is an uniform distribution on all positive integers.  DP(gamma,G) is a Dirichlet Process on integers with concentration parameter gamma and base measure G. DP(alpha,G_m) is a Dirichlet Process on integers with concentration parameter alpha and base measure G_m. The choice of F() and H0() can be described by an arbitrary "BasicBayesian" object such as "GaussianGaussian","GaussianInvWishart","GaussianNIW", "GaussianNIG", "CatDirichlet", and "CatDP". See \code{?BasicBayesian} for definition of "BasicBayesian" objects, and see for example \code{?GaussianGaussian} for specific "BasicBayesian" instances. As a summary, An "HDP2" object is simply a combination of a "CatHDP2" object (see \code{?CatHDP2}) and an object of any "BasicBayesian" type.\cr
In the case of HDP2, u, z and k can only be positive integers. \cr
The sufficient statistics of a set of samples x in a "HDP2" object is the same sufficient statistics of the "BasicBayesian" inside the "HDP2", see examples.
}
\examples{
## a HDP2 with Gaussian NIW observations
obj1 <- HDP2(gamma=list(gamma=1,alpha=1,j=2,m=2,
                        H0aF="GaussianNIW",
                        parH0=list(m=0,k=1,v=2,S=1)))
## a HDP2 with Categorical-Dirichlet observations
obj2 <- HDP2(gamma=list(gamma=1,alpha=1,j=2,m=2,
                        H0aF="CatDirichlet",
                        parH0=list(alpha=1,uniqueLabels=letters[1:3])))
x1 <- rnorm(100)
x2 <- sample(letters[1:3],100,replace = TRUE)
w <- runif(100)
sufficientStatistics_Weighted(obj = obj1,x=x1,w=w,foreach = FALSE)
sufficientStatistics_Weighted(obj = obj2,x=x2,w=w,foreach = FALSE)
sufficientStatistics_Weighted(obj = obj1,x=x1,w=w,foreach = TRUE)
}
\references{
Teh, Yee W., et al. "Sharing clusters among related groups: Hierarchical Dirichlet processes." Advances in neural information processing systems. 2005.
}
\seealso{
\code{\link{HDP2}}, \code{\link{sufficientStatistics.HDP2}}
}
