% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bcc.R
\name{bcc}
\alias{bcc}
\title{Beta Control Charts}
\usage{
bcc(data, type = c("1", "2"), sizes, center, std.dev, limits, data.name,
  labels, newdata, newsizes, newdata.name, newlabels, nsigmas = 3,
  confidence.level = 0.9, rules = shewhart.rules, plot = TRUE, ...)
}
\arguments{
\item{data}{a data frame, a matrix or a vector containing observed data for the variable to chart. Each row of a data frame or a matrix, and each value of a vector, refers to a sample or ''rationale group''.}

\item{type}{a character string specifying the group statistics to compute. There are two possible types: \code{1} for discrete data and \code{2} for continuous data.}

\item{sizes}{a value or a vector of values specifying the sample sizes associated with each group. If data is continuous this parameter should be ignored}

\item{center}{a value specifying the center of group statistics or the ''target'' value of the process.}

\item{std.dev}{a value or an available method specifying the within-group standard deviation(s) of the process.}

\item{limits}{a two-values vector specifying control limits.}

\item{data.name}{a string specifying the name of the variable which appears on the plots. If not provided is taken from the object given as data.}

\item{labels}{a character vector of labels for each group.}

\item{newdata}{a data frame, matrix or vector, as for the \code{data} argument, providing further data to plot but not included in the computations.}

\item{newsizes}{a vector as for the \code{sizes} argument providing further data sizes to plot but not included in the computations.}

\item{newdata.name}{a string specifying the name of the variable which appears on the plots. If not provided is taken from the object given as newdata.}

\item{newlabels}{a character vector of labels for each new group defined in the argument \code{newdata}.}

\item{nsigmas}{a numeric value specifying the number of sigmas to use for computing control limits. It is ignored when the \code{confidence.level} argument is  provided.}

\item{confidence.level}{a numeric value between 0 and 1 specifying the confidence level of the computed probability limits.}

\item{rules}{a value or a vector of values specifying the rules to apply to the chart. See \link[qcc]{shewhart.rules} for possible values and their meaning.}

\item{plot}{logical. If \code{TRUE} a Shewhart chart is plotted.}

\item{...}{further arguments are ignored.}
}
\value{
Returns an object of class \code{'qcc'}.
}
\description{
Create an object of class \code{'qcc'} to perform statistical quality control. This object may then be used to plot Beta Control Charts.
}
\details{
The Beta Chart presents the control limits based on the Beta probability distribution.  It was can be used for monitoring fraction data from Binomial distribution as replacement of the p-Charts. The Beta Chart was applied for monitoring the variables in three real studies, and it was compared to the control limits with three schemes. The comparative analysis showed that: (i) Beta approximation to the Binomial distribution was more appropriate with values confined in the [0, 1]- interval; and (ii) the charts proposed were more sensitive to the average run length (ARL), in both in-control and out-of-control processes monitoring. The Beta Charts outperform the Shewhart control charts analyzed for monitoring fraction data.This package was made based on the qcc package. See \link[qcc]{qcc}.
}
\examples{
data("Drapper1998data")
bcc(data = Drapper1998data, type = "2")
data("Montgomery2005")
bcc(data=Montgomery2005$Defective, sizes = Montgomery2005$Sample, type=1)


}
\references{
SANT'ANNA, Ângelo M. O; CATEN, Carla Schwengber ten. Beta control charts forsave monitoring fraction data. Expert Systems With Applications, p. 10236-10243. 1 set. 2012.

Scrucca, L. (2004). qcc: an R package for quality control charting and statistical process control. \emph{R News} 4/1, 11-17.
}
