% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stock.R
\name{stock}
\alias{stock}
\alias{stocks}
\title{Stock prices}
\usage{
stock(x)

stocks(...)
}
\arguments{
\item{x, ...}{Company name as returned by the \code{\link[=get_today]{get_today()}} function}
}
\value{
Returns a \code{data.frame} containing all the historical data for the specified stock.
\itemize{
\item \code{date}: the date of the given record.
\item \code{open}: the opening price of the stock on \code{date}.
\item \code{high}:  the highest price.
\item \code{low}:  the lowest price.
\item \code{close}:  the closing price.
\item \code{volume}: Volume of stocks traded on \code{date}.
}

If the plural variant is used it'll add a \code{symbol} column that'll contain the name of the company.
}
\description{
Scraps \href{http://leboursier.ma/}{\strong{Le Boursier}}'s and gets the historical prices for the specified companies.
}
\examples{
head(stock("Wafa Assur"), 20)
head(stock(), 20) # same as runing stock("MASI")
head(stock("MADEX"), 20)
head(stocks("Masi", "MADEX"), 20)
}
