% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bdc_basisOfRecords_notStandard.R
\name{bdc_basisOfRecords_notStandard}
\alias{bdc_basisOfRecords_notStandard}
\title{Identify records from doubtful source (e.g., 'fossil', MachineObservation')}
\usage{
bdc_basisOfRecords_notStandard(
  data,
  basisOfRecord = "basisOfRecord",
  names_to_keep = "all"
)
}
\arguments{
\item{data}{data.frame. Containing information about the basis of records.}

\item{basisOfRecord}{character string. The column name with information about
basis of records. Default = "basisOfRecord".}

\item{names_to_keep}{character string. Elements of the column BasisOfRecords
to keep. Default is "all", which considers a selected list of recommended
standard Darwin Core classes (and their spelling variations, see details).
By default, records missing (i.e., NA) or with "unknown" information about
basis of records are kept.}
}
\value{
A data.frame containing the column ".basisOfRecords_notStandard"
.Compliant (TRUE) if 'basisOfRecord' is standard; otherwise "FALSE".
}
\description{
This function flags records with an informed basis of records (i.e., the
records type, for example, a specimen, a human observation, or a fossil
specimen) not interpretable, which does not comply with Darwin Core
vocabulary, or unreliable or unsuitable for specific analyses.
}
\details{
Users are encourage to select the set of basis of records classes
to keep. Default = c("Event","HUMAN_OBSERVATION", "HumanObservation",
"LIVING_SPECIMEN", "LivingSpecimen", "MACHINE_OBSERVATION",
"MachineObservation", "MATERIAL_SAMPLE", "O", "Occurrence",
"MaterialSample", "OBSERVATION", "Preserved Specimen",
"PRESERVED_SPECIMEN", "preservedspecimen Specimen", "Preservedspecimen",
"PreservedSpecimen", "preservedspecimen", "S", "Specimen", "Taxon",
"UNKNOWN", "", NA)
}
\examples{
x <- data.frame(basisOfRecord = c(
  "FOSSIL_SPECIMEN", "UNKNOWN",
  "RON", NA, "Specimen", "PRESERVED_SPECIMEN"
))

bdc_basisOfRecords_notStandard(
  data = x, 
  basisOfRecord = "basisOfRecord",
  names_to_keep = "all"
)
}
\seealso{
Other prefilter: 
\code{\link{bdc_coordinates_country_inconsistent}()},
\code{\link{bdc_coordinates_empty}()},
\code{\link{bdc_coordinates_from_locality}()},
\code{\link{bdc_coordinates_outOfRange}()},
\code{\link{bdc_coordinates_transposed}()},
\code{\link{bdc_country_standardized}()},
\code{\link{bdc_scientificName_empty}()}
}
\concept{prefilter}
