% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ExtractorYtbid.R
\docType{class}
\name{ExtractorYtbid}
\alias{ExtractorYtbid}
\title{Class to handle comments of YouTube files with ytbid extension}
\usage{
ExtractorYtbid
}
\description{
This class inherits from the \code{\link{Instance}} class and
implements the functions of extracting the text and the date of an ytbid type file.
}
\section{Constructor}{

\code{ExtractorYtbid$new(path)}
\itemize{
\item{\emph{Arguments:}}{
\itemize{
\item{\strong{path:}}{
(\emph{character}) path of the ytbid type file.
}
}
}
}
}

\section{Details}{

YouTube conection is handled through the \code{\link{Connections}} class
which loads the YouTube API credentials from the configuration file.
Additionally, to increase the processing speed, each youtube query is stored
in a cache to avoid the execution of duplicated queries. To enable this option,
cache location should be in the \emph{cachePathYtbid} indicated in the
\emph{cache} section from the configuration file. This variable has to be the
path to store the comments and it is neccesary that it has two folder named:
"_spam_" and "_ham_"

\strong{[cache]}

cachePathYtbid = \emph{<<cache_path_ytbid>>}
}

\section{Inherit}{

This class inherits from \code{\link{Instance}} and implements the
\code{obtainSource} and \code{obtainDate} abstracts functions.
}

\section{Methods}{

\itemize{
\item{\bold{obtainId:}}{
obtains the id of the ytbid. Read the id of the file indicated
in the variable path.
\itemize{
\item{\emph{Usage:}}{
\code{obtainId()}
}
}
}
\item{\bold{getId:}}{
gets of comment ID.
\itemize{
\item{\emph{Usage:}}{
\code{getId()}
}
\item{\emph{Value:}}{
value of comment ID.
}
}
}
\item{\bold{obtainDate:}}{
obtains the date from a specific comment ID. If the comment has been previously
cached the comment date is loaded from cache path. Otherwise, the request is
perfomed using YouTube API and the date is then formatted to the established
standard.
\itemize{
\item{\emph{Usage:}}{
\code{obtainDate()}
}
}
}
\item{\bold{obtainSource:}}{
obtains the source from a specific comment ID. If the comment has previously
been cached the source is loaded from cache path. Otherwise, the request is
performed using on YouTube API.
\itemize{
\item{\emph{Usage:}}{
\code{obtainSource()}
}
}
}
}
}

\section{Private fields}{

\itemize{
\item{\bold{id:}}{
 (\emph{character}) ID of comment.
}
}
}

\seealso{
\code{\link{ExtractorEml}}, \code{\link{ExtractorSms}},
\code{\link{ExtractorTwtid}}, \code{\link{Instance}}
}
