% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plm_methods.R
\name{plot.plm0}
\alias{plot.plm0}
\alias{plot.plm}
\alias{plot.gplm0}
\alias{plot.gplm}
\title{Plot method for discharge rating curves}
\usage{
\method{plot}{plm0}(x, type = "rating_curve", param = NULL, transformed = FALSE, ...)

\method{plot}{plm}(x, type = "rating_curve", param = NULL, transformed = FALSE, ...)

\method{plot}{gplm0}(x, type = "rating_curve", param = NULL, transformed = FALSE, ...)

\method{plot}{gplm}(x, type = "rating_curve", param = NULL, transformed = FALSE, ...)
}
\arguments{
\item{x}{object of class "plm0", "plm", "gplm0" or "gplm".}

\item{type}{a character denoting what type of plot should be drawn. Defaults to "rating_curve". Possible types are
\itemize{
   \item{"rating_curve"}{ to plot the rating curve.}
   \item{"rating_curve_mean"}{ to plot the posterior mean of the rating curve.}
   \item{"f"}{ to plot the power-law exponent.}
   \item{"beta"}{ to plot the random effect in the power-law exponent.}
   \item{"sigma_eps"}{ to plot the standard deviation on the data level.}
   \item{"residuals"}{ to plot the log residuals.}
   \item{"trace"}{ to plot trace plots of parameters given in param.}
   \item{"histogram"}{ to plot histograms of parameters given in param.}
   \item{"panel"}{ to plot a 2x2 panel of plots: "rating curve", "residuals", "f" and "sigma_eps"}
}}

\item{param}{a character vector with the parameters to plot. Defaults to NULL and is only used if type is "trace" or "histogram". Allowed values are the parameters given in the model summary of x as well as "hyperparameters" or "latent_parameters" for specific groups of parameters.}

\item{transformed}{a logical value indicating whether the quantity should be plotted on a transformed scale used during the Bayesian inference. Defaults to FALSE.}

\item{...}{further arguments passed to other methods. Currently supports:
\itemize{
  \item{"title"}{ a character denoting the title of the plot}
  \item{"xlim"}{ numeric vector of length 2, denoting the limits on the x axis of the plot. Applicable for types "rating_curve","rating_curve_mean","f","beta"\cr,"sigma_eps","residuals".}
  \item{"ylim"}{ numeric vector of length 2, denoting the limits on the y axis of the plot. Applicable for types "rating_curve","rating_curve_mean","f","beta"\cr,"sigma_eps","residuals".}
}}
}
\value{
No return value, called for side effects.
}
\description{
Visualize discharge rating curve model objects
}
\section{Functions}{
\itemize{
\item \code{plot.plm0}: Plot method for plm0

\item \code{plot.plm}: Plot method for plm

\item \code{plot.gplm0}: Plot method for gplm0

\item \code{plot.gplm}: Plot method for gplm
}}

\examples{
\donttest{
data(krokfors)
set.seed(1)
plm0.fit <- plm0(formula=Q~W,data=krokfors,num_cores=2)

plot(plm0.fit)
plot(plm0.fit,transformed=TRUE)
plot(plm0.fit,type='histogram',param='c')
plot(plm0.fit,type='histogram',param='c',transformed=TRUE)
plot(plm0.fit,type='histogram',param='hyperparameters')
plot(plm0.fit,type='histogram',param='latent_parameters')
plot(plm0.fit,type='residuals')
plot(plm0.fit,type='f')
plot(plm0.fit,type='sigma_eps')
}
}
\seealso{
\code{\link{plm0}}, \code{\link{plm}}, \code{\link{gplm0}} and \code{\link{gplm}} for fitting a discharge rating curve and \code{\link{summary.plm0}}, \code{\link{summary.plm}}, \code{\link{summary.gplm0}} and \code{\link{summary.gplm}} for summaries. It is also useful to look at \code{\link{spread_draws}} and \code{\link{gather_draws}} to work directly with the MCMC samples.
}
