% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/turning_points.R
\name{do_find_turning_points}
\alias{do_find_turning_points}
\title{Find turning points}
\usage{
do_find_turning_points(.x, .return = c("value", "index"), .adjust = 1.5, ...)
}
\arguments{
\item{.x}{A numeric vector}

\item{.return}{A character giving the desired return type.}

\item{.adjust}{A numeric giving the adjustment to the \code{adjust} argument of \code{\link[stats:density]{stats::density()}}.}

\item{...}{Other parameters passed to \code{\link[stats:density]{stats::density()}}}
}
\value{
A list with the two elements \code{maxima} and \code{minima}
}
\description{
Find turning points (minima and maxima) in a vector.
}
\examples{
set.seed(1234)
.x <- c(rnorm(100, 2, 1), rnorm(100, 9, 1))
tpi <- do_find_turning_points(.x, .return = "index", .adjust = 1)

dx <- density(.x, adjust = 1, n = length(.x))
plot(dx)
points(dx$x[tpi$maxima], dx$y[tpi$maxima], pch = 19, col = "red")
points(dx$x[tpi$minima], dx$y[tpi$minima], pch = 19, col = "blue")

do_find_turning_points(.x, .return = "value", .adjust = 1)
}
\keyword{internal}
