% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/beanz_present.R
\name{summary.stan}
\alias{r.forest.stan}
\alias{r.plot.stan}
\alias{r.summary.stan}
\alias{summary.stan}
\title{Posterior subgroup treatment effects}
\usage{
r.summary.stan(stan.rst, sel.grps = NULL, ref.stan.rst = NULL,
  ref.sel.grps = 1, cut = 0, digits = 3)

r.plot.stan(stan.rst, sel.grps = NULL, ref.stan.rst = NULL,
  ref.sel.grps = 1, ...)

r.forest.stan(stan.rst, sel.grps = NULL, ref.stan.rst = NULL,
  ref.sel.grps = 1, ..., quants = c(0.025, 0.975))
}
\arguments{
\item{stan.rst}{a class \code{beanz.stan} object generated by
\code{\link{call.stan}}}

\item{sel.grps}{an array of subgroup numbers to be included in the summary results}

\item{ref.stan.rst}{a class \code{beanz.stan} object from \code{\link{call.stan}} that
is used as the reference}

\item{ref.sel.grps}{subgroups from the reference model to be included in the
summary table}

\item{cut}{cut point to compute the probabiliby that the posterior subgroup
treatment effects is below}

\item{digits}{number of digits in the summary result table}

\item{...}{options for \code{plot} function}

\item{quants}{lower and upper quantiles of the credible intervals in the
forest plot}
}
\value{
\code{r.summary.stan} generates a dataframe with summary statistics
    of the posterior treatment effect for the selected subgroups.
    \code{r.plot.stan} generates the density plot of the posterior treatment
    effects for the selected subgroups. \code{r.forest.stan}
    generates the forest plot of the posterior treatment
    effects.
}
\description{
Present the posterior subgroup treatment effects
}
\examples{
\dontrun{
sel.grps <- c(1,4,5);
tbl.sub <- r.summary.stan(rst.sr, ref.stan.rst=rst.nse, ref.sel.grps=1);
r.plot.stan(rst.sr, sel.grps = sel.grps, ref.stan.rst=rst.nse, ref.sel.grps=1);
r.forest.stan(rst.sr, sel.grps = sel.grps, ref.stan.rst=rst.nse, ref.sel.grps=1);}

}
\seealso{
\code{\link{call.stan}}
}

