% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/install_beast2.R
\name{install_beast2}
\alias{install_beast2}
\title{Install BEAST2}
\usage{
install_beast2(folder_name = rappdirs::user_data_dir(),
  verbose = FALSE, os = rappdirs::app_dir()$os)
}
\arguments{
\item{folder_name}{name of the folder where the BEAST2 files will
be put.
The name of the BEAST2 binary file will be at
\code{[folder_name]/beast/bin/beast}
The name of the BEAST2 jar file will be at
\code{[folder_name]/beast/lib/beast.jar}}

\item{verbose}{if TRUE, additional information is displayed, that
is potentially useful in debugging}

\item{os}{name of the operating system,
must be \code{unix} (Linux, Mac) or \code{win} (Windows)}
}
\value{
Nothing. Will install BEAST2
}
\description{
Install BEAST2
}
\examples{
  library(testthat)

  if (is_on_ci()) {

    if (!is_beast2_installed()) {
      install_beast2()
    }
    expect_true(file.exists(get_default_beast2_path()))
    expect_true(file.exists(get_default_beast2_bin_path()))
    expect_true(file.exists(get_default_beast2_jar_path()))
  }
}
\author{
Richèl J.C. Bilderbeek
}
