% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run_beast2_from_options.R
\name{run_beast2_from_options}
\alias{run_beast2_from_options}
\title{Run BEAST2}
\usage{
run_beast2_from_options(beast2_options = create_beast2_options())
}
\arguments{
\item{beast2_options}{a set of BEAST2 options,
that are the R equivalent of the BEAST2 command-line options,
as can be created by \link{create_beast2_options}}
}
\description{
Run BEAST2
}
\examples{
  library(testthat)

  if (is_beast2_installed() && is_on_ci()) {

    beast2_options <- create_beast2_options(
      input_filename = get_beastier_path("2_4.xml")
    )

    expect_false(file.exists(beast2_options$output_log_filename))
    expect_false(file.exists(beast2_options$output_trees_filenames))
    expect_false(file.exists(beast2_options$output_state_filename))

    output <- run_beast2_from_options(beast2_options)

    expect_true(length(output) > 40)
    expect_true(file.exists(beast2_options$output_log_filename))
    expect_true(file.exists(beast2_options$output_trees_filenames))
    expect_true(file.exists(beast2_options$output_state_filename))
  }
}
\author{
Richèl J.C. Bilderbeek
}
