% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_beast2_internal_filenames.R
\name{check_beast2_internal_filenames}
\alias{check_beast2_internal_filenames}
\title{Check if the \code{beast2_internal_filenames}
is a valid BEAST2 internal filenames object.}
\usage{
check_beast2_internal_filenames(beast2_internal_filenames)
}
\arguments{
\item{beast2_internal_filenames}{a list of internally
used BEAST2 filenames,
as created by \link{create_beast2_internal_filenames}}
}
\value{
nothing
}
\description{
Calls \code{stop} if the BEAST2 internal filenames object is invalid
}
\examples{
library(testthat)

if (beastier::is_beast2_installed()) {
  expect_silent(
    check_beast2_internal_filenames(
      create_beast2_internal_filenames(
        create_beast2_options(
          input_filename = get_beastier_path("2_4.xml")
        )
      )
    )
  )
}

# Must stop on nonsense
expect_error(check_beast2_internal_filenames("nonsense"))
expect_error(check_beast2_internal_filenames(NULL))
expect_error(check_beast2_internal_filenames(NA))
}
\seealso{
Use \link{create_beast2_internal_filenames}
  to create a valid BEAST2 internal filenames object
}
\author{
Richèl J.C. Bilderbeek
}
