% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_beast2_example_filename.R
\name{get_beast2_example_filename}
\alias{get_beast2_example_filename}
\title{Get the full path of a BEAST2 example file}
\usage{
get_beast2_example_filename(
  filename,
  beast2_folder = get_default_beast2_folder()
)
}
\arguments{
\item{filename}{name of the BEAST2 example file. This should exclude
the full path; this function exists to add that full path}

\item{beast2_folder}{the folder where the BEAST2 is installed.
Note that this is not the folder where the BEAST2 executable
is installed: the BEAST2 executable is in a subfolder.
Use \link{get_default_beast2_folder} to get the default BEAST2
folder.
Use \link{get_default_beast2_bin_path} to get the full path to
the default BEAST2 executable.}
}
\description{
Will \link{stop} if the filename is not a BEAST2 example file
}
\examples{
library(testthat)

if (is_beast2_installed()) {
  filename <- get_beast2_example_filename("testJukesCantor.xml")
  expect_true(file.exists(filename))

  filename <- get_beast2_example_filename("Primates.nex")
  expect_true(file.exists(filename))

  expect_error(get_beast2_example_filename("abs.ent"))
}
}
