% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_param.R
\name{create_beta_param}
\alias{create_beta_param}
\alias{create_param_beta}
\title{Create a parameter called beta}
\usage{
create_beta_param(id = NA, estimate = FALSE, value = 1)
}
\arguments{
\item{id}{the parameter's ID}

\item{estimate}{TRUE if this parameter alpha be estimated by BEAST2,
FALSE otherwise}

\item{value}{value of the parameter}
}
\value{
a parameter called beta
}
\description{
Create a parameter called beta
}
\note{
this parameter is used in a beta distribution
  (as returned by \code{\link{create_beta_distr}})
and gamma distribution
  (as returned by \code{\link{create_gamma_distr}})
and inverse gamma distribution
  (as returned by \code{\link{create_inv_gamma_distr}})
}
\examples{
  # Create the parameter
  beta_param <- create_beta_param()

  # Use the parameter in a distribution
  gamma_distr <- create_gamma_distr(
    beta = beta_param
  )

  # Use the distribution to create a BEAST2 input file
  create_beast2_input_file(
    input_filenames = get_fasta_filename(),
    "create_beta_param.xml",
    tree_priors = create_yule_tree_prior(
      birth_rate_distr = gamma_distr
    )
  )
  testit::assert(file.exists("create_beta_param.xml"))
}
\seealso{
the function \code{\link{create_param}} contains a list
  of all parameters that can be created
}
\author{
Richel J.C. Bilderbeek
}
