% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_gamma_site_model.R
\name{create_gamma_site_model}
\alias{create_gamma_site_model}
\title{Create a gamma site model, part of a site model}
\usage{
create_gamma_site_model(gamma_cat_count = "0", gamma_shape = "1.0",
  prop_invariant = "0.0", gamma_shape_prior_distr = create_exp_distr(id =
  NA, mean = create_mean_param(id = 0, value = "1.0")),
  freq_equilibrium = "estimated")
}
\arguments{
\item{gamma_cat_count}{the number of gamma categories, must
be an integer with value zero or more}

\item{gamma_shape}{gamma curve shape parameter}

\item{prop_invariant}{the proportion invariant, must be a value
from 0.0 to 1.0}

\item{gamma_shape_prior_distr}{the distribution of the gamma shape prior}

\item{freq_equilibrium}{the frequency in which the rates are at equilibrium
are either \code{estimated}, \code{empirical} or \code{all_equal}.
\code{\link{get_freq_equilibrium_names}} returns the possible values
for \code{freq_equilibrium}}
}
\value{
a gamma site model
}
\description{
Create a gamma site model, part of a site model
}
\note{
Use \code{\link{create_site_model}} to create a site model
  that has both a gamma site model and substitution model
}
\examples{
  gamma_site_model <- create_gamma_site_model(prop_invariant = 0.5)

  site_model <- create_hky_site_model(gamma_site_model = gamma_site_model)

  create_beast2_input_file(
    get_fasta_filename(),
    "create_gamma_site_model.xml",
    site_model = site_model
  )
  testit::assert(file.exists("create_gamma_site_model.xml"))
}
\author{
Richel J.C. Bilderbeek
}
