% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_param.R
\name{create_scale_param}
\alias{create_scale_param}
\alias{create_param_scale}
\title{Create a parameter called scale}
\usage{
create_scale_param(id = NA, estimate = FALSE, value = 0)
}
\arguments{
\item{id}{the parameter's ID}

\item{estimate}{TRUE if this parameter scale be estimated by BEAST2,
FALSE otherwise}

\item{value}{value of the parameter}
}
\value{
a parameter called scale
}
\description{
Create a parameter called scale
}
\note{
this parameter is used in a Laplace distribution
  (as returned by \code{\link{create_laplace_distr}})
}
\examples{
  # Create the parameter
  scale_param <- create_scale_param()

  # Use the parameter in a distribution
  laplace_distr <- create_laplace_distr(
    scale = scale_param
  )

  # Use the distribution to create a BEAST2 input file
  create_beast2_input_file(
    input_filenames = get_fasta_filename(),
    "create_scale_param.xml",
    tree_priors = create_yule_tree_prior(
      birth_rate_distr = laplace_distr
    )
  )
  testit::assert(file.exists("create_scale_param.xml"))
}
\seealso{
the function \code{\link{create_param}} contains a list
  of all parameters that can be created
}
\author{
Richel J.C. Bilderbeek
}
