% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcmc_to_xml_run.R
\name{mcmc_to_xml_run_nested_sampling}
\alias{mcmc_to_xml_run_nested_sampling}
\title{Converts an MCMC object to the run section's XML for a Nested-Sampling MCMC}
\usage{
mcmc_to_xml_run_nested_sampling(mcmc)
}
\arguments{
\item{mcmc}{one MCMC
as returned by \code{\link{create_mcmc}}}
}
\value{
the XML as text
}
\description{
Converts an MCMC object to the run section's XML for a Nested-Sampling MCMC
}
\examples{
library(testthat)

xml <- mcmc_to_xml_run_nested_sampling(
  create_ns_mcmc()
)

expect_equal(
  xml,
  paste0(
    "<run id=\\"mcmc\\" spec=\\"beast.gss.NS\\" chainLength=\\"1e+07\\" ",
    "particleCount=\\"1\\" subChainLength=\\"5000\\" epsilon=\\"1e-12\\">"
  )
)
}
\author{
Richèl J.C. Bilderbeek
}
