% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/is_distr.R
\name{is_normal_distr}
\alias{is_normal_distr}
\title{Determine if the object is a valid
normal distribution
as created by \code{\link{create_normal_distr}}}
\usage{
is_normal_distr(x)
}
\arguments{
\item{x}{an object, to be determined if it is a valid
normal distribution}
}
\value{
TRUE if x is a valid normal distribution,
  FALSE otherwise
}
\description{
Determine if the object is a valid
normal distribution
as created by \code{\link{create_normal_distr}}
}
\examples{
library(testthat)

expect_true(is_normal_distr(create_normal_distr()))

expect_false(is_normal_distr(create_one_div_x_distr()))
expect_false(is_normal_distr(NA))
expect_false(is_normal_distr(NULL))
expect_false(is_normal_distr("nonsense"))
}
\seealso{
use \code{\link{is_distr}} to see if x is any
  distribution
}
\author{
Richèl J.C. Bilderbeek
}
