% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/taxa_to_xml_tree.R
\name{taxa_to_xml_tree}
\alias{taxa_to_xml_tree}
\title{Internal function}
\usage{
taxa_to_xml_tree(inference_model)
}
\arguments{
\item{inference_model}{a Bayesian phylogenetic inference model.
An inference model is the complete model setup in which a site model,
clock model, tree prior and more are specified.
Use \link{create_inference_model} to create an inference model.
Use \link{check_inference_model} to check if  an inference model is valid.
Use \link{rename_inference_model_filenames} to rename the files in an
inference model.}
}
\value{
lines of XML text
}
\description{
Internal function to creates the '\code{tree}' section
of a BEAST2 XML parameter file,
which is part of a '\code{state}' section,
without being indented.
}
\details{
The \code{tree} tag has these elements:
\preformatted{
   <tree[...]>
       <taxonset[...]>
       [...]
       </taxonset>
    </run>
}
}
\author{
Richèl J.C. Bilderbeek
}
