% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/foo.R
\name{dfplot2}
\alias{dfplot2}
\title{Plot a dataframe, one y against multiple xs}
\usage{
dfplot2(x, y, xlab = "x", ylab = "y", xlim = NULL, ylim = NULL, mycol = NULL, 
    mylty = NULL, xerror = NULL, yerror = NULL, mycolerrorbar = NULL, mylegend = NULL)
}
\arguments{
\item{x}{a vector  or a dataframe with the same length as x}

\item{y}{a vector}

\item{xlab}{character}

\item{ylab}{character}

\item{xlim}{numeric}

\item{ylim}{numeric}

\item{mycol}{colours}

\item{mylty}{numeric}

\item{xerror}{errorbar, same dimension of x}

\item{yerror}{same dimension of y}

\item{mycolerrorbar}{error bar colours}

\item{mylegend}{character}
}
\value{
a figure
}
\description{
Plot a dataframe, one y against multiple xs
}
\examples{
x <- seq(0, 2 * pi, length.out = 100)
y <- data.frame(sin(x), cos(x))
yerror <- data.frame(abs(rnorm(100, sd = 0.3)), abs(rnorm(100, sd = 0.1)))
dfplot2(y, x, xerror = yerror)

}
