% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/legendmt.R
\name{legendmt}
\alias{legendmt}
\title{legend with multiline title}
\usage{
legendmt(
  x,
  y = NULL,
  legend,
  title,
  x.intersp = 1,
  fill = NA,
  col = par("col"),
  border = NA,
  lty = NA,
  lwd = NA,
  pch = NA,
  ...
)
}
\arguments{
\item{x, y, legend}{Arguments as in \code{\link{legend}}}

\item{title}{Character with linebreaks or vector of charstrings.}

\item{x.intersp, fill, col, border, lty, lwd, pch}{Arguments as in \code{\link{legend}}}

\item{\dots}{Further arguments passed to \code{\link{legend}}.
If vectorized, please remember to prepend NAs or whatever.}
}
\value{
\code{\link{legend}} output
}
\description{
Draw a legend with title spanning several lines (i.e. with line breaks).
Note that this is in development and not all inputs are correctly vectorized yet.
}
\examples{
plot(1:10)
  legend("topleft", letters[1:4], col=1:4, pch=1, title="very long title to be split up")
legendmt("topleft", letters[1:4], col=1:4, pch=1, title="very long title\nnow splat up")

# Alternative:
plot(1:10)
legend("topleft", "very long title to be split up")
legend("topleft", letters[1:4], col=1:4, pch=1, inset=c(0,0.09) )

}
\seealso{
\code{\link{legend}}
}
\author{
Berry Boessenkool, \email{berry-b@gmx.de}, Apr 2017
}
\keyword{aplot}
