% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classification.R
\name{LL.ROC}
\alias{LL.ROC}
\title{ROC curves for the Livingston and Lewis approach.}
\usage{
LL.ROC(
  x = NULL,
  reliability,
  min = 0,
  max = 1,
  truecut,
  true.model = "4P",
  error.model = "Binomial",
  AUC = FALSE,
  maxJ = FALSE,
  raw.out = FALSE,
  grainsize = 100
)
}
\arguments{
\item{x}{A vector of observed results.}

\item{reliability}{The reliability coefficient of the test.}

\item{min}{The minimum possible value to attain on the observed-score scale. Default is 0 (assuming \code{x} represent proportions).}

\item{max}{The maximum possible value to attain on the observed-score scale. Default is 1 (assuming \code{x} represent proportions).}

\item{truecut}{The true point along the x-scale that marks the categorization-threshold.}

\item{true.model}{The probability distribution to be fitted to the moments of the true-score distribution. Options are \code{"4P"} (default) and \code{"2P"}, referring to four- and two-parameter Beta distributions. The "4P" method produces a four-parameter Beta distribution with the same first four moments (mean, variance, skewness, and kurtosis) as the estimated true-score distribution, while the "2P" method produces a two-parameter Beta distribution with the first two moments (mean and variance) as the estimated true-score distribution.}

\item{error.model}{The probability distribution to be used for producing the sampling distributions at different points of the true-score scale. Options are \code{binomial} and \code{beta}. The binomial distribution is discrete, and is the distribution used originally by Livingston and Lewis. Use of the binomial distribution involves a rounding of the effective test length to the nearest integer value. The Beta distribution is continuous, and does not involve rounding of the effective test length.}

\item{AUC}{Calculate and include the area under the curve? Default is \code{FALSE}.}

\item{maxJ}{Mark the point along the curve where Youden's J statistic is maximized? Default is \code{FALSE}.}

\item{raw.out}{Give raw coordinates as output rather than plot? Default is \code{FALSE}.}

\item{grainsize}{Specify the number of cutoff-points for which the ROC curve is to be calculated. The greater this number the greater the accuracy. Default is 100 points.}
}
\value{
A plot tracing the ROC curve for the test, or matrix of coordinates if raw.out is \code{TRUE}.
}
\description{
Generate a ROC curve plotting the false-positive rate against the true-positive rate at different cut-off values across the observed proportion-score scale.
}
\examples{
# Generate some fictional data. Say, 100 individuals take a test with a
# maximum score of 100 and a minimum score of 0.
set.seed(1234)
testdata <- rbinom(100, 100, rBeta.4P(100, .25, .75, 5, 3))
hist(testdata, xlim = c(0, 100))

# Suppose the cutoff value for attaining a pass is 50 items correct, and
# that the reliability of this test was estimated to 0.7. To produce a plot
# with an ROC curve using LL.ROC(), along with the AUC statistics and the
# points at which Youden's J. is maximized:
LL.ROC(x = testdata, reliability = .7, truecut = 50, min = 0, max = 100,
AUC = TRUE, maxJ = TRUE)
}
