% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/betafunctions.R
\name{dGammaBinom}
\alias{dGammaBinom}
\title{Probability density function under the Gamma-extended Binomial distribution.}
\usage{
dGammaBinom(x, size, prob, nc = FALSE)
}
\arguments{
\item{x}{Vector of quantiles.}

\item{size}{Number of "trials" (zero or more). Need not be integer.}

\item{prob}{Probability of "success" on each "trial". Need not be integer.}

\item{nc}{Whether to include a normalizing constant making sure that the sum of the distribution's density is 1.}
}
\description{
Probability density function under the Gamma-extended Binomial distribution.
}
\examples{
#' # Assume some variable follows a Gamma-Binomial distribution with
# "number of trials" = 10.5 and probability of "success" for each "trial"
# = 0.75, to compute the probability density to attain a "number of success"
# at a specific point (e.g., 7.5 "successes"):
dGammaBinom(x = 7.5, size = 10.5, prob = 0.75)

# Including a normalizing constant (then diverges from binomial dist.):
dGammaBinom(x = 7.5, size = 10.5, prob = 0.75, nc = TRUE)
dGammaBinom(x = 7, size = 10, prob = 0.75) == dbinom(7, 10, 0.75)
dGammaBinom(x = 7, size = 10, prob = 0.75, nc = TRUE) == dbinom(7, 10, 0.75)
}
\references{
Loeb, D. E. (1992). A generalization of the binomial coefficients. Discrete Mathematics, 105(1-3).
}
