% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compress_chars.R
\name{char_map}
\alias{char_map}
\alias{map2char}
\title{Split a Character Vector into its Unique Elements and a Mapping on These}
\usage{
char_map(x)

map2char(map)
}
\arguments{
\item{x}{a character vector. Long vectors are supported.}

\item{map}{an object as returned by \code{char_map}.}
}
\value{
\code{char_map} returns an S3 object of class "char_map", which is a
  list with the following elements: (chars) the unique set of strings in
  \code{x} in undefined order, (idx) an integer (or - for long vectors -
  double) vector such that \code{map$chars[map$idx]} is identical to \code{x}
  (except maybe for attributes), (attributes) the attributes of x as a
  shallow copy of the corresponding pairlist.

\code{map2char} returns a character vector identical to \code{x},
  including attributes.
}
\description{
This is implemented using a radix sort on the CHARSXPs directly, i.e. on the
addresses of the strings in the global string cache. Hence, in contrast to
\code{\link[base]{unique}}, this function does not consider two strings equal
which differ only in their encoding. Also, the order of the unique elements
is undefined.
}
\section{Lifecycle}{

  \ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options:
  alt='[Stable]'}}}{\strong{[Stable]}}
}

\examples{
x <- sample(letters, 100, replace = TRUE)
map <- char_map(x)
stopifnot(identical(x, map$chars[map$idx]))

names(x) <- 1:100
stopifnot(identical(x, map2char(char_map(x))))

}
