% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bgmfiles-package.r
\docType{package}
\name{bgmfiles}
\alias{bgmfiles}
\alias{bgmfiles-package}
\title{bgmfiles.}
\usage{
bgmfiles(pattern = NULL)
}
\arguments{
\item{pattern}{optional pattern string to filter files returned, see \code{\link{list.files}} for details}
}
\value{
character vector of file paths
}
\description{
Raw data files are maintained here: \url{https://github.com/AustralianAntarcticDivision/box-geometry-models.git}

Return the full paths to all files in the extdata/bgm/ folder of this package.
}
\details{
This package contains a simple workflow to update from that source repo and install the raw files into extdata/ of the installed package.
}
\examples{
## obtain all example files installed
bfiles <- bgmfiles()
print(basename(bfiles))

## filter based on an input pattern
afiles <- bgmfiles(pattern = "^antarc")
print(basename(afiles))

## read all the text from all files and table raw characters
## (for no reason)
lapply(bfiles, function(x) table(unlist(strsplit(paste(readLines(x), collapse = ""), ""))))
}

