% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/biclique.R
\name{bi.clique}
\alias{bi.clique}
\title{Biclique enumeration}
\usage{
bi.clique(filename, lleast = 1, rleast = 1, version = 1, filetype = 0,
  envir = .GlobalEnv$.bienv)
}
\arguments{
\item{filename}{Input file name}

\item{lleast}{Least number of left partite <default = 1>}

\item{rleast}{Least number of right partite <default = 1>}

\item{version}{Algorithm version <default = 1> [1|2]}

\item{filetype}{Input file format <default = 0>. 0-edge list, 1-binary matrix.}

\item{envir}{biclique environment}
}
\description{
This function will compute the bicliques and output the statistics of these bicliques.
If you want to get bicliques above a threshold, you can change the values of lleast and rleast.
The input file should be tab delimited with number of vertices and edges at the head of the input file.
If your input file does not have these values, you can use function bi.format to add these values to it.
This package supports edgelist and binary matrix file format.
Two versions of algorithms are implemented in this function, you can choose either one to get bicliques.
}
\examples{
bicliques = bi.clique(system.file("extdata", "example1.el", package = "biclique"))
bicliques = bi.clique(system.file("extdata", "example1.el", package = "biclique"), 3, 2)
bicliques = bi.clique(system.file("extdata", "example4.bmat", package = "biclique"), filetype = 1)
# check a biclique
bicliques$biclique1

}
