% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoplot.biclustermd.R
\name{autoplot.biclustermd}
\alias{autoplot.biclustermd}
\title{Make a heatmap of sparse biclustering results}
\usage{
\method{autoplot}{biclustermd}(object, reorder = FALSE,
  transform_colors = FALSE, c = 1/6, cell_alpha = 1/5,
  col_clusts = NULL, row_clusts = NULL, ...)
}
\arguments{
\item{object}{An object of class "biclustermd".}

\item{reorder}{A logical. If TRUE, heatmap will be sorted according to the cell-average matrix, \code{A}.}

\item{transform_colors}{If equals `TRUE` then the data is scaled by
`c` and run through a standard normal cdf before plotting. If `FALSE` (default), raw data
values are used in the heat map.}

\item{c}{Value to scale the data by before running it through a standard normal CDF.
Default is 1/6.}

\item{cell_alpha}{A scalar defining the transparency of shading over a cell and by default this equals 1/5.
The color corresponds to the cell mean.}

\item{col_clusts}{A vector of column cluster indices to display. If NULL (default), all are displayed.}

\item{row_clusts}{A vector of row cluster indices to display. If NULL (default), all are displayed.}

\item{...}{Arguments to be passed to `geom_vline()` and `geom_hline()`.}
}
\value{
An object of class ggplot.
}
\description{
Make a heatmap of sparse biclustering results
}
\examples{
data("synthetic")

bc <- biclustermd(synthetic, col_clusters = 3, row_clusters = 2,
                miss_val = mean(synthetic, na.rm = TRUE),
                miss_val_sd = sd(synthetic, na.rm = TRUE),
                col_min_num = 2, row_min_num = 2,
                col_num_to_move = 1, row_num_to_move = 1,
                max.iter = 10)
bc
autoplot(bc)

autoplot(bc) + ggplot2::scale_fill_distiller(palette = "Spectral", na.value = "white")

# Complete shading
autoplot(bc, cell_alpha = 1)

# Transformed values and no shading
autoplot(bc, transform_colors = TRUE, c = 1/20, cell_alpha = 0)

# Focus on row cluster 1 and column cluster 2
autoplot(bc, col_clusts = 2, row_clusts = 1)

}
