% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class002-bids_class_base.R
\name{new_bids_class}
\alias{new_bids_class}
\title{Create new \code{bidsr} class definition}
\usage{
new_bids_class(
  name,
  parent = BIDSClassBase,
  abstract = FALSE,
  hidden_names = NULL,
  properties = NULL,
  methods = NULL,
  validator = NULL,
  constructor = NULL
)
}
\arguments{
\item{name}{string, required, name of the class}

\item{parent}{parent class definition, needs to be a \code{'S7'} class}

\item{abstract}{whether the class is abstract (\code{TRUE}) or not
(\code{FALSE})}

\item{hidden_names}{vector of string, names of properties and/or methods
whose presence should be hidden from the users; this will affect \code{`$`}
operator, or \code{\link{names}} function. The hidden properties or methods
cannot be queried via these two ways. However, properties can still be
accessible via \code{`@`} operator}

\item{properties}{a named list where the names are the property names
that can be queried via \code{`$`} or \code{`@`} operators}

\item{methods}{read-only methods for the class, such as \code{format}
and \code{print}; if a method is a function, then the arguments
should start with \code{self} (instance method) or \code{cls} (class method).
In most of the cases, changes made to the object will not be carrier out
once the the method function exits. For changes to the properties,
use \code{setter} functions in each property.}

\item{validator}{validate function; see \code{\link[S7]{new_class}}}

\item{constructor}{function to custom the constructor; see parameter
\code{'constructor'} at \code{\link[S7]{new_class}} for details. Basically
A custom constructor should call
\code{\link[S7:new_object]{S7::new_object()}} to
create the \code{'S7'} object. The first argument should be an instance
of the parent class (if used). The subsequent arguments are used to set
the properties.}
}
\value{
A \code{S7} object inheriting the \code{'bidsr::BIDSClassBase'}
class.
}
\description{
By default, all generated classes inherit \code{\link{BIDSClassBase}},
which provides \code{S3} generics
}
\examples{

# ---- Basic usage --------------------------------------------

Range <- new_bids_class(
  "Range",
  properties = list(
    start = bids_property_numeric("start", "required"),
    end = bids_property_numeric("end", "optional")
  ),
  validator = function(self) {
    if(length(self@end) && self@end < self@start) {
      "@end must be great than or equal to @start"
    }
  }
)


r <- Range(start = 10)
r
# get and set properties with @ or $
r$start
r$end <- 40
r$end

try(Range(start = c(10, 15), end = 20))
try(Range(start = 15, end = 10))



# ---- hide properties and attributes -------------------------
MyClass <- new_bids_class(
  name = "MyClass",
  properties = list(
    str = bids_property_character(
      name = "str", type = "required"),
    hidden_prop = bids_property_character("hidden_prop")
  ),
  methods = list(
    # read-only methods
    format = function(self, ...) {
      sprintf("MyClass@str -> \%s", self$str)
    },
    hidden_method = function(self) {
      "Nonononono"
    }
  ),
  hidden_names = c("hidden_method", "hidden_prop")
)

x <- MyClass(str = "a")
x

# hidden names will not be displayed
names(x)
as.list(x)

# however, then can still be queried
x$hidden_prop
x$hidden_method()




}
\author{
Zhengjia Wang
}
