% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bfa.boot2fast.ls.R
\name{bfa.boot2fast.ls}
\alias{bfa.boot2fast.ls}
\title{Fast Double Bootstrap of Least Squares Estimators of BAR(p) Models}
\usage{
bfa.boot2fast.ls(z, p, burn = 5, B)
}
\arguments{
\item{z}{a numeric vector containing the tree data}

\item{p}{an integer determining the order of bifurcating autoregressive model
to be fit to the data}

\item{burn}{number of tree generations to discard before starting the
bootstrap sample (replicate)}

\item{B}{number of bootstrap samples (replicates) used in first round of
bootstrapping}
}
\value{
\item{boot.est}{a matrix containing the first-stage bootstrapped
least squares estimates of the autoregressive coefficients} \item{boot2}{a
matrix containing the second-stage bootstrapped least squares estimates of
the autoregressive coefficients}
}
\description{
This function performs fast double bootstrapping of the least squares
estimators of the autoregressive coefficients in a bifurcating autoregressive
(BAR) model of any order \code{p} as described in Elbayoumi & Mostafa (2020).
}
\examples{
z <- bfa.tree.gen(31, 1, 1, 1, 0.5, 0.5, 0, 10, c(0.7))
bfa.boot2fast.ls(z, p=1, B=499)
}
\references{
Elbayoumi, T. M. & Mostafa, S. A. (2020). On the estimation bias
in bifurcating autoregressive models. \emph{Stat}, 1-16.
}
