% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/biglm.big.matrix.R
\name{bigglm.big.matrix}
\alias{bigglm.big.matrix}
\alias{biglm.big.matrix}
\title{Use Thomas Lumley's ``biglm'' package with a ``big.matrix''}
\usage{
bigglm.big.matrix(formula, data, chunksize = NULL, ..., fc = NULL,
  getNextChunkFunc = NULL)

biglm.big.matrix(formula, data, chunksize = NULL, ..., fc = NULL,
  getNextChunkFunc = NULL)
}
\arguments{
\item{formula}{a model \code{\link{formula}}.}

\item{data}{a \code{\link[bigmemory]{big.matrix}}.}

\item{chunksize}{an integer maximum size of chunks of data to process
iteratively.}

\item{fc}{either column indices or names of variables that are factors.}
\item{\dots}{options associated with the \code{\link[biglm]{biglm}}}

\item{getNextChunkFunc}{a function which retrieves chunk data}
}
\value{
an object of class \code{biglm}
}
\description{
This is a wrapper to Thomas Lumley's 
\code{\link[biglm]{biglm}} package, allowing it to be used with massive 
data stored in \code{\link[bigmemory]{big.matrix}} objects.
}
\examples{
\dontrun{
library(bigmemory)
x <- matrix(unlist(iris), ncol=5)
colnames(x) <- names(iris)
x <- as.big.matrix(x)
head(x)

silly.biglm <- biglm.big.matrix(Sepal.Length ~ Sepal.Width + Species,
                                data=x, fc="Species")
summary(silly.biglm)

y <- data.frame(x[,])
y$Species <- as.factor(y$Species)
head(y)

silly.lm <- lm(Sepal.Length ~ Sepal.Width + Species, data=y)
summary(silly.lm)
}
}

