% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/divide_conquer_mds.R
\name{divide_conquer_mds}
\alias{divide_conquer_mds}
\title{Divide and Conquer MDS}
\usage{
divide_conquer_mds(x, l, s, k)
}
\arguments{
\item{x}{Data matrix.}

\item{l}{The highest value where classical MDS can be computed efficiently.}

\item{s}{Number of sampling points. It should be 2 x estimated data dimension.}

\item{k}{Number of principal coordinates.}
}
\value{
Returns MDS based on Divide and Conquer MDS as well as the first k eigenvalues.
\describe{
\item{points}{MDS}
\item{eigen}{eigenvalues}
}
}
\description{
Performs Multidimensional Scaling based on Delicado and Pachon-Garcia, 2020.
}
\examples{
x <- matrix(data = rnorm(4*10000, sd = 10), nrow = 10000)
cmds <- divide_conquer_mds(x = x, l = 100, s = 8, k = 2)
head(cmds$points)
cmds$eigen
}
\seealso{
\url{https://arxiv.org/abs/2007.11919}
}
