\name{bigcforest-class}
\Rdversion{1.1}
\docType{class}
\alias{bigcforest-class}
\alias{show,bigcforest-method}
\alias{summary,bigcforest-method}
\title{Classification Random Forests}
\description{
  Class representing a classification random forest.
}
\section{Objects from the Class}{
  Objects can be created by calls of the form \code{new("bigcforest", ...)}, but most often are generated by \code{\link[bigrf]{bigrfc}}.
}
\section{Slots}{
  \describe{
    \item{\code{.Data}:}{Object of class \code{"list"}. Each element is a \code{"\linkS4class{bigctree}"}, representing a tree in the random classification forest.}
    \item{\code{nexamples}:}{Object of class \code{"integer"}. Number of examples in the training set (including synthesized examples for unsupervised learning).}
    \item{\code{varselect}:}{Object of class \code{"integer"}. Indices of the columns of \code{x} that were used to train the model.}
    \item{\code{factorvars}:}{Object of class \code{"logical"}. Indicates which variables are factors or categorical (\code{TRUE})), and which are numeric (\code{FALSE}).}
    \item{\code{varnlevels}:}{Object of class \code{"integer"}. Number of levels in each categorical variable, or \code{0} for numeric variables.}
    \item{\code{contvarseq}:}{Object of class \code{"integer"}. Maps the continuous variables in \code{varselect} to the columns in \code{big.matrix} \code{a}. Meant for internal use by \code{bigrfc} or \code{grow} when growing trees.}
    \item{\code{y}:}{Object of class \code{"factor"}. Class labels for the training set.}
    \item{\code{ytable}:}{Object of class \code{"table"}. Counts of training examples in each class.}
    \item{\code{yclasswts}:}{Object of class \code{"matrix"}. One-dimensional matrix of scaled weights for each class.}
    \item{\code{ntrees}:}{Object of class \code{"integer"}. Number of trees in the forest.}
    \item{\code{nsplitvar}:}{Object of class \code{"integer"}. Number of variables to split on at each node.}
    \item{\code{maxndsize}:}{Object of class \code{"integer"}. Maximum number of examples in each node when growing the trees.}
    \item{\code{maxeslevels}:}{Object of class \code{"integer"}. Maximum number of levels for categorical variables for which exhaustive search of possible splits will be performed.}
    \item{\code{nrandsplit}:}{Object of class \code{"integer"} Number of random splits to examine for categorical variables with more than \code{maxeslevels} levels.}
    \item{\code{oobtimes}:}{Object of class \code{"integer"}. Number of times each training example has been out-of-bag.}
    \item{\code{oobvotes}:}{Object of class \code{"matrix"}. Out-of-bag votes for each training example.}
    \item{\code{oobpred}:}{Object of class \code{"integer"}. Out-of-bag predictions for each training example.}
    \item{\code{trainclserr}:}{Object of class \code{"numeric"}. Training errors of out-of-bag examples, by class.}
    \item{\code{trainerr}:}{Object of class \code{"numeric"}. Total training error of out-of-bag examples.}
    \item{\code{trainconfusion}:}{Object of class \code{"table"}. Confusion matrix for out-of-bag examples.}
    \item{\code{varginidec}:}{Object of class \code{"numeric"}. Decrease in Gini impurity for each variable over all trees.}
    \item{\code{cachepath}:}{Object of class \code{"character.or.NULL"}. Path to folder where data caches used in building the forest were stored, or \code{NULL} if data was processed completely in memory.}
  }
}
\section{Extends}{
  Class \code{"\linkS4class{list}"}, from data part.\cr
  Class \code{"\linkS4class{vector}"}, by class "list", distance 2.
}
\section{Methods}{
  \describe{
    \item{grow}{\code{signature(forest = "bigcforest")}: Grow more trees in the random forest, using the same parameters. See \code{\link[bigrf]{grow}} for details.}
    \item{merge}{\code{signature(x = "bigcforest", y = "bigcforest")}: Merge two random forests into one. See \code{\link[bigrf]{merge}} for details.}
    \item{predict}{\code{signature(object = "bigcforest")}: Predict the classes of a set of test examples. See \code{\link[bigrf]{predict}} for details.}
    \item{varimp}{\code{signature(forest = "bigcforest")}: Compute variable importance based on out-of-bag estimates. See \code{\link[bigrf]{varimp}} for details.}
    \item{fastimp}{\code{signature(forest = "bigcforest")}: Compute fast (Gini) variable importance. See \code{\link[bigrf]{fastimp}} for details.}
    \item{interactions}{\code{signature(forest = "bigcforest")}: Compute variable interactions. See \code{\link[bigrf]{interactions}} for details.}
    \item{proximities}{\code{signature(forest = "bigcforest")}: Compute the proximity matrix. See \code{\link[bigrf]{proximities}} for details.}
    \item{prototypes}{\code{signature(forest = "bigcforest", prox = "bigrfprox")}: Compute class prototypes. See \code{\link[bigrf]{prototypes}} for details.}
    \item{show}{\code{signature(object = "bigcforest")}: Print the random forest.}
    \item{summary}{\code{signature(object = "bigcforest")}: Print summary information on the random forest, including out-of-bag training error estimates and the confusion matrix.}
  }
}
\keyword{classes}
\keyword{models}
\keyword{tree}
