% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subset-QC.R
\name{snp_subset}
\alias{snp_subset}
\alias{subset.bigSNP}
\title{Subset a bigSNP}
\usage{
snp_subset(
  x,
  ind.row = rows_along(x$genotypes),
  ind.col = cols_along(x$genotypes),
  backingfile = NULL
)

\method{subset}{bigSNP}(
  x,
  ind.row = rows_along(x$fam),
  ind.col = rows_along(x$map),
  backingfile = NULL,
  ...
)
}
\arguments{
\item{x}{A \link[=bigSNP-class]{bigSNP}.}

\item{ind.row}{Indices of the rows (individuals) to keep.
Negative indices \strong{can} be used to exclude row indices.
Default: keep them all.}

\item{ind.col}{Indices of the columns (SNPs) to keep.
Negative indices \strong{can} be used to exclude column indices.
Default: keep them all.}

\item{backingfile}{Prefix of the two new files created (".bk" and ".rds").
By default, it is automatically determined by appending "_sub" and a number
to the prefix of the input bigSNP backing files.}

\item{...}{Not used.}
}
\value{
The path to the RDS file that stores the \code{bigSNP} object.
}
\description{
Subset (copy) of a \code{bigSNP}, also stored on disk.
}
\examples{
str(test <- snp_attachExtdata())

# keep only first 50 samples and SNPs
rdsfile <- snp_subset(test, ind.row = 1:50, ind.col = 1:50)
str(snp_attach(rdsfile))

# remove only first 50 samples and SNPs
rdsfile2 <- snp_subset(test, ind.row = -(1:50), ind.col = -(1:50))
str(snp_attach(rdsfile2))

}
\seealso{
\link[=bigSNP-class]{bigSNP}
}
