% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitLinear.R
\name{fitLinear}
\alias{fitLinear}
\title{Linear regression}
\usage{
fitLinear(X, y)
}
\arguments{
\item{X}{a numeric matrix.}

\item{y}{a numeric vector.}
}
\value{
A number, the log-likelihood.
}
\description{
Fit the linear regression model and calculate the log-likelihood.
}
\examples{
set.seed(1)
n <- 100
M <- 10
X <- matrix(rnorm(M*n), ncol=M)
y <- X[, 2] - X[, 3] + X[, 6] - X[, 10] + rnorm(n)
fitLinear(X, y)
}

