% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/presencePlot.R
\name{presencePlot}
\alias{presencePlot}
\title{Creates two maps: a map showing how many times the category is present during the time series and
a map showing how many times the category changes during the time series.}
\usage{
presencePlot(
  input,
  pltunit = "m",
  dataEpsg = 32632,
  scalePos = "bottomleft",
  narrowPos = "topright",
  narrowSize = 1,
  categoryName = "marsh",
  xAxis = "Longitude (m)",
  yAxis = "Latitude (m)",
  axisText = 1.2,
  axisLabel = 1.2,
  plotTitle = 1.5
)
}
\arguments{
\item{input}{is the results from running the "changeData" function.}

\item{pltunit}{is the unit which the current map is plotted in, one of cm, m, km, in, ft, mi. or lat or lon.
This parameter is optional if "dataEpsg" is passed.}

\item{dataEpsg}{is the projection of the current map. If extents are valid lat or lons,
the projection is assumed to be lat and lon (EPSG:4326), or Spherical Mercator otherwise (EPSG:3857).
This is done to work seamlessly with "OpenStreetMap" packages.currently it is set to 32632.}

\item{scalePos}{where to align the scale bar. One of "bottomleft", "bottomright", "topleft", or "topright".}

\item{narrowPos}{where to align the north arrow. One of "bottomleft", "bottomright", "topleft", or "topright".}

\item{narrowSize}{is a numeric value indicating the size of the north arrow.}

\item{categoryName}{is a character representing the name of the category of interest.Default is "marsh".}

\item{xAxis}{is a character indicating a label for the horizontal axis. The default is "Longitude (m)".}

\item{yAxis}{is a character indicating a label for the vertical axis.The default is "Latitude (m)".}

\item{axisText}{is a numeric value controlling the size of the text on the horizontal and vertical ticks.}

\item{axisLabel}{is a numeric value controlling the size of the  horizontal and vertical labels}

\item{plotTitle}{is a numeric value controlling the size of the plot title.}
}
\value{
The output from \code{\link{presencePlot}}
}
\description{
Creates two maps: a map showing how many times the category is present during the time series and
a map showing how many times the category changes during the time series.
}
\examples{
example_data <- terra::rast(system.file("external/Example_raster_Y.tif",package="binaryTimeSeries"))
no_data <- 2
cat_interest <- 1
data_res <- c(1000,1000)
data_prj <- "+proj=utm +zone=32 +datum=WGS84 +ellps=GRS80  +units=m +no_defs"
chdata_output <- changeData(x = example_data,nodata = no_data,
category = cat_interest,spres = data_res,datacrs = data_prj)
ch_maps <- presencePlot(input = chdata_output,pltunit = "m",dataEpsg = 32632,
scalePos = "bottomleft",narrowPos = "topright",narrowSize = 1,
categoryName = "category",xAxis = "Horizontal (m)",yAxis = "Vertical (m)",
axisText = 1.2,axisLabel = 1.2,plotTitle = 1.5)

}
