% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plugin_dist.R
\name{bw.dist.binned}
\alias{bw.dist.binned}
\title{Plug-in bandwidth selector for kernel distribution estimation and binned data.}
\usage{
bw.dist.binned(n, y, w, ni, gplugin, type = "N", confband = F, B = 1000,
  alpha = 0.05, plot = TRUE, print = TRUE, model, pars = new.env())
}
\arguments{
\item{n}{Positive integer. Size of the complete sample.}

\item{y}{Vector. Observed values. They define the extremes of the sequence of intervals in which data is binned.}

\item{w}{Vector. Proportion of observations within each interval.}

\item{ni}{Vector. Number of observations within each interval.}

\item{gplugin}{Positive real number. Pilot bandwidth. If missing, rule-of-thumb bandwidth is considered.}

\item{type}{Character. If \code{type} = "N", normality is assumed at the last step when calculating the plug-in bandwidth. If \code{type} = "A", parameter at last step is estimated nonparametrically using \code{gplugin} as bandwidth. Otherwise, the unknown parameter is estimated fitting a normal mixture. Defaults to \code{type} = "N".}

\item{confband}{Logical. If TRUE, bootstrap confidence bands for the distribution are constructed. Defaults to FALSE.}

\item{B}{Number of bootstrap resamples. Defaults to 1000.}

\item{alpha}{Significance level for the bootstrap confidence bands. Defaults to 0.05.}

\item{plot}{Logical. If TRUE, results are plotted. Defaults to TRUE.}

\item{print}{Logical. If TRUE, script current status is printed. Defaults to TRUE.}

\item{model}{Character. Name of the parametric family of distributions to be fitted for the censored sample. Parameters are estimated by maximum likelihood.}

\item{pars}{Environment. Needed for the well functioning of the script. DO NOT modify this argument.}
}
\value{
A list with components
\item{h}{Plug-in bandwidth.}
\item{Fh}{Function. Kernel distribution estimator with bandwidth \code{h}.}
\item{confband}{(Optional) Bootstrap confidence bands for the distribution function.}
}
\description{
Plug-in bandwidth selector for kernel distribution estimation and binned data.
}
\examples{
set.seed(1)
n <- 200 #complete sample size
k <- 30 #number of intervals
x <- rnorm(n,6,1) #complete sample
y <- seq(min(x)-0.2,max(x)+0.2,len=k+1) #intervals
w <- c(sapply(2:k,function(i)sum( x<y[i]&x>=y[i-1] )), sum(x<=y[k+1]&x>=y[k]) )/n #proportions
bw.dist.binned(n,y,w,plot=FALSE)

}
\references{
\insertRef{TesisMiguel2015}{binnednp}

\insertRef{Phalaris2016}{binnednp}
}
