\name{pdb2aln.ind}
\alias{pdb2aln.ind}
\title{ Mapping between PDB atomic indices and alignment positions }
\description{
  Find the best alignment between a PDB structure and an 
  existing alignment. Then, given a set of residue indices
  defined for the original alignment, return the equivalent 
  CA atom indices in the PDB coordinates.
}
\usage{
pdb2aln.ind(aln, pdb, inds, ...)
}
\arguments{
  \item{aln}{ an alignment list object with \code{id} and \code{ali}
    components, similar to that generated by \code{\link{read.fasta}},
    \code{\link{read.fasta.pdb}}, and \code{\link{seqaln}}. }
  \item{pdb}{ the PDB object. }
  \item{inds}{ a numeric vector with a subset of the alignment position indices. }
  \item{\dots}{ additional arguments for the function \code{\link{pdb2aln}}. }
}
\details{
  Call the function \code{\link{pdb2aln}} to align the PDB sequence to
  the existing alignment. Then find the equivalent CA atomic indices in 
  PDB to \code{inds}. 
}
\value{
  Returns a numeric vector with the equivalent CA atomic indices.
}
\references{
  Grant, B.J. et al. (2006) \emph{Bioinformatics} \bold{22}, 2695--2696.
}
\author{ Xin-Qiu Yao & Barry Grant }
\seealso{ \code{\link{seq2aln}}, \code{\link{seqaln.pair}},
       \code{\link{pdb2aln}} }
\examples{
\dontrun{
##--- Read aligned PDB coordinates (CA only)
aln  <- read.fasta(system.file("examples/kif1a.fa",package="bio3d"))
pdbs <- read.fasta.pdb(aln)

##--- Read PDB coordinate for a new structure (all atoms)
id <- get.pdb("2kin", URLonly=TRUE)
pdb <- read.pdb(id)

# map the non-gap positions
gap.inds <- gap.inspect(pdbs$resno)
npc.inds <- pdb2aln.ind(aln=pdbs, pdb=pdb, id=id, inds=gap.inds$f.inds)

# If gaps are found in PDB sequence with the predefined indices,
# redefine the non-gap positions
ngap.f.inds <- gap.inds$f.inds[!is.na(npc.inds)]
npc.inds <- npc.inds[!is.na(npc.inds)]

##--- fit the atomic coordinates to the aligned X-ray structure
xyz <- fit.xyz(pdbs$xyz[1,], pdb$xyz, atom2xyz(ngap.f.inds), atom2xyz(npc.inds))

## seq2aln(pdbseq(pdb), aln, id = id)
## do we get the same result

}

}
\keyword{ utilities }

