% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_pvolfile.R
\name{read_pvolfile}
\alias{read_pvolfile}
\title{Read a polar volume (\code{pvol}) from file}
\usage{
read_pvolfile(file, param = c("DBZH", "VRADH", "VRAD", "RHOHV", "ZDR",
  "PHIDP", "CELL"), sort = TRUE, lat, lon, height, elev_min = 0,
  elev_max = 90, verbose = TRUE, mount = dirname(file))
}
\arguments{
\item{file}{A string containing the path to a vertical profile generated
by \link[bioRad]{calculate_vp}.}

\item{param}{An atomic vector of character strings, containing the names
of scan parameters to read. To read all scan parameters use 'all'.}

\item{sort}{A logical value, when \code{TRUE} sort scans ascending
by elevation.}

\item{lat}{Latitude in decimal degrees of the radar position. If not
specified, value stored in file is used. If specified, value stored in
file is overwritten.}

\item{lon}{Longitude in decimal degrees of the radar position. If not
specified, value stored in file is used. If specified, value stored in
file is overwritten.}

\item{height}{Height of the center of the antenna in meters above sea
level. If not specified, value stored in file is used. If specified, value
stored in file is overwritten.}

\item{elev_min}{Minimum scan elevation to read in degrees.}

\item{elev_max}{Maximum scan elevation to read in degrees.}

\item{verbose}{A logical value, whether to print messages (\code{TRUE})
to console.}

\item{mount}{A character string with the mount point (a directory path)
for the Docker container.}
}
\value{
An object of class \link[=summary.pvol]{pvol}, which is a list
containing polar scans, i.e. objects of class \code{scan}
}
\description{
Read a polar volume (\code{pvol}) from file
}
\details{
Scan parameters are named according to the OPERA data information
model (ODIM), see Table 16 in the
\href{https://github.com/adokter/vol2bird/blob/master/doc/OPERA2014_O4_ODIM_H5-v2.2.pdf}{ODIM specification}.
Commonly available parameters are:
\describe{
 \item{"\code{DBZH}", "\code{DBZ}"}{(Logged) reflectivity factor [dBZ]}
 \item{"\code{VRADH}", "\code{VRAD}"}{Radial velocity [m/s]. Radial
   velocities towards the radar are negative, while radial velocities away
   from the radar are positive}
 \item{"\code{RHOHV}"}{Correlation coefficient [unitless]. Correlation
   between vertically polarized and horizontally polarized reflectivity
   factor}
 \item{"\code{PHIDP}"}{Differential phase [degrees]}
 \item{"\code{ZDR}"}{(Logged) differential reflectivity [dB]}
}
}
\examples{
# locate example volume file:
pvol <- system.file("extdata", "volume.h5", package = "bioRad")
# print the local path of the volume file:
pvol
# load the file:
vol <- read_pvolfile(pvol)
# print summary info for the loaded polar volume:
vol
# print summary info for the scans in the polar volume:
vol$scans
# copy the first scan to a new object 'scan'
scan <- vol$scans[[1]]
# print summary info for the new object:
scan
}
