% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/docker.R
\name{update_docker}
\alias{update_docker}
\title{Update Docker image from Docker hub}
\usage{
update_docker(mistnet = FALSE)
}
\arguments{
\item{mistnet}{logical. When True, installs MistNet segmentation model,
downloading an additional 1GB Docker image
(see \link{apply_mistnet} for details).}
}
\value{
the POSIXct creation date of the installed Docker image
}
\description{
Pulls and installs the latest Docker image used by bioRad from Docker hub
}
\details{
This command pulls the latest
\href{https://hub.docker.com/r/adokter/vol2bird/}{vol2bird} Docker image
from \href{https://hub.docker.com}{Docker hub}.
Run this command to ensure all Docker functionality (e.g. the
\link{calculate_vp} function) runs at the latest available version.

To install the MistNet segmentation model into bioRad,
run \code{update_docker(mistnet = TRUE)}
}
\examples{
\dontrun{
# update the vol2bird docker image:
update_docker()
}
}
