vp <- example_vp
scan <- example_scan

# No tests for error on incorrect parameters:
# summary(), print(), dim() are generic and work for every input
# is.vp() returns TRUE/FALSE and works for every input

test_that("c.vp() returns error on incorrect parameters", {
  expect_error(c(vp, "not_a_vp"), "Each element must be a `vp` object.", fixed = TRUE)
})

test_that("summary.vp() prints metadata to the console", {
  # print.vp() is not tested as it is the same as and called from summary.vp()
  expect_output(summary(vp), "Vertical profile (class vp)", fixed = TRUE)
  expect_output(summary(vp), "radar:", fixed = TRUE)
  expect_output(summary(vp), "source:", fixed = TRUE)
  expect_output(summary(vp), "nominal time:", fixed = TRUE)
  expect_output(summary(vp), "generated by:", fixed = TRUE)
})

test_that("summary.vp() warns for legacy objects", {
  names(vp$data) <- sub("height", "HGHT", names(vp$data)) # Rename to legacy "HGHT"
  expect_warning(summary(vp), "`x` is a legacy `vp` object without a column `height`.", fixed = TRUE)
})

test_that("is.vp() returns TRUE/FALSE correctly", {
  expect_true(is.vp(vp))
  expect_false(is.vp("not_a_vp"))
  expect_false(is.vp(scan))
})

test_that("dim.vp() returns number of heights, quantities", {
  expect_vector(dim(vp))
  expect_equal(dim(vp), c(25, 16)) # 25 heights, 17 quantities in example_vp
})

test_that("c.vp() warns if vp are not of same radar", {
  vp_other_radar <- vp
  vp_other_radar$radar <- "test"
  expect_warning(c(vp, vp_other_radar), "Vertical profiles are not from a single radar.")
})
