% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all-generics.R, R/gbFeatureTable-class.R,
%   R/gbRecord-class.R, R/gbRecordList-class.R
\docType{methods}
\name{featureTable}
\alias{featureTable}
\alias{featureTable,gbFeatureTable-method}
\alias{featureTable,gbRecord-method}
\alias{featureTable,gbRecordList-method}
\title{Tabulate Genbank features}
\usage{
featureTable(x, ...)

\S4method{featureTable}{gbFeatureTable}(x)

\S4method{featureTable}{gbRecord}(x)

\S4method{featureTable}{gbRecordList}(x)
}
\arguments{
\item{x}{A \code{\linkS4class{gbFeatureTable}}, \code{\linkS4class{gbRecord}},
or \code{\linkS4class{gbRecordList}} object.}

\item{...}{Additional arguments to be passed to or from methods.}
}
\value{
A \code{\link{table}} (or list of \code{table}s) of 
   feature keys.
}
\description{
Extract a frequency table (or list of tables in the case of
\code{gbRecordList}s) of feature keys.
}
\examples{
load(system.file("extdata", "marine_metagenome.rda", package = "biofiles"))
featureTable(x)
}
\seealso{
\code{\link{qualifTable}}
}
