% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all-generics.R, R/gbFeature-class.R,
%   R/gbFeatureTable-class.R, R/gbRecord-class.R, R/gbRecordList-class.R
\docType{methods}
\name{index}
\alias{index}
\alias{index,gbFeature-method}
\alias{index,gbFeatureTable-method}
\alias{index,gbRecord-method}
\alias{index,gbRecordList-method}
\title{Access the indices of GenBank features}
\usage{
index(x, ...)

\S4method{index}{gbFeature}(x)

\S4method{index}{gbFeatureTable}(x)

\S4method{index}{gbRecord}(x)

\S4method{index}{gbRecordList}(x)
}
\arguments{
\item{x}{A \code{\linkS4class{gbFeature}}, \code{\linkS4class{gbFeatureTable}},
\code{\linkS4class{gbRecord}}, or \code{\linkS4class{gbRecordList}} object.}

\item{...}{Additional arguments passed to methods.}
}
\value{
A numeric vector of feature indeces.
}
\description{
Access the indices of GenBank features
}
\examples{
load(system.file("extdata", "marine_metagenome.rda", package = "biofiles"))
index(x)
}
