% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_ed.R
\name{validate_encoding}
\alias{validate_encoding}
\title{Validate encoding}
\usage{
validate_encoding(x, u)
}
\arguments{
\item{x}{encoding.}

\item{u}{\code{integer}, \code{numeric} or \code{character} vector of all
elements belonging to the encoding. See Details.}
}
\value{
\code{TRUE} if the \code{x} is a correctly reduced \code{u}, 
\code{FALSE} in any other cases.
}
\description{
Checks the structure of an encoding.
}
\details{
The encoding is a list of groups to which elements of an alphabet 
should be reduced. All elements of the alphabet (all 
amino acids or all nucleotides) should appear in the encoding.
}
\examples{
enc1 = list(`1` = c("a", "t"), 
            `2` = c("g", "c"))
# see if enc1 is the correctly reduced nucleotide (DNA) alphabet
validate_encoding(enc1, c("a", "c", "g", "t"))

# enc1 is not the RNA alphabet, so the results is FALSE
validate_encoding(enc1, c("a", "c", "g", "u"))

# validate_encoding works also on other notations
enc2 = list(a = c(1, 4),
            b = c(2, 3))
validate_encoding(enc2, 1L:4)
}
\seealso{
\code{\link{calc_ed}}: calculate the encoding distance between two encodings.
\code{\link{encoding2df}}: converts an encoding to a data frame.
}
\keyword{manip}

