% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict_stochastic_growth.R
\name{predict_stochastic_growth}
\alias{predict_stochastic_growth}
\title{Isothermal growth with variability}
\usage{
predict_stochastic_growth(
  model_name,
  times,
  n_sims,
  mean_logN0,
  sd_logN0,
  mean_sqmu,
  sd_sqmu,
  mean_sqlambda,
  sd_sqlambda,
  mean_logNmax,
  sd_logNmax,
  corr_matrix = diag(4)
)
}
\arguments{
\item{model_name}{Character describing the primary growth model.}

\item{times}{Numeric vector of storage times for the simulations}

\item{n_sims}{Number of simulations}

\item{mean_logN0}{Mean value of the initial log microbial count.}

\item{sd_logN0}{Standard error of the initial log microbial count.}

\item{mean_sqmu}{Mean value of the square root of the maximum
specific growth rate.}

\item{sd_sqmu}{Standard error of the square root of the maximum
specific growth rate.}

\item{mean_sqlambda}{Mean value of the square root of the lag phase duration.}

\item{sd_sqlambda}{Standard error of the square root of the lag phase duration.}

\item{mean_logNmax}{Mean value of the maximum log microbial count.}

\item{sd_logNmax}{Standard error of the maximum log microbial count.}

\item{corr_matrix}{Correlation matrix of the model parameters. Defined in the
order (logN0, sqrt(mu), sqrt(lambda), logNmax). A diagonal matrix by default
(uncorrelated parameters).}
}
\value{
A list of class \code{StochasticGrowth} with the items:
\itemize{
\item sample: parameter sample used for the calculations.
\item simulations: growth curves predicted for each parameter.
\item quantiles: limits of the credible intervals (5%, 10%, 50%, 90%, 95%) for
each time point.
\item model: Model used for the calculations.
\item mus: Mean parameter values used for the simulations.
\item sigma: Variance-covariance matrix used for the simulations.
}
}
\description{
Stochastic simulation of microbial growth based on probability
distributions of the parameters of the primary model.
}
\details{
Simulations are limited to multivariate normal distributions of
the model parameters.
}
\examples{
\donttest{
## Definition of the simulation settings

my_model <- "Trilinear"
my_times <- seq(0, 30, length = 100)
n_sims <- 3000

## Call the function

stoc_growth <- predict_stochastic_growth(my_model, my_times, n_sims,
    mean_logN0 = 0, sd_logN0 = .2,
    mean_sqmu = 2,sd_sqmu = .3,
    mean_sqlambda = 4, sd_sqlambda = .4,
    mean_logNmax = 6, sd_logNmax = .5)

## We can plot the results

plot(stoc_growth)

## Adding parameter correlation

my_cor <- matrix(c(1,   0,   0, 0,
    0,   1, 0.7, 0,
    0, 0.7,   1, 0,
    0,   0,   0, 1),
    nrow = 4)

stoc_growth2 <- predict_stochastic_growth(my_model, my_times, n_sims,
    mean_logN0 = 0, sd_logN0 = .2,
    mean_sqmu = 2,sd_sqmu = .3,
    mean_sqlambda = 4, sd_sqlambda = .4,
    mean_logNmax = 6, sd_logNmax = .5,
    my_cor)

plot(stoc_growth2)
}

}
