% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GrowthPrediction_class.R
\name{GrowthPrediction}
\alias{GrowthPrediction}
\alias{print.GrowthPrediction}
\alias{summary.GrowthPrediction}
\alias{plot.GrowthPrediction}
\alias{coef.GrowthPrediction}
\title{GrowthPrediction class}
\usage{
\method{print}{GrowthPrediction}(x, ...)

\method{summary}{GrowthPrediction}(object, ...)

\method{plot}{GrowthPrediction}(
  x,
  y = NULL,
  ...,
  add_factor = NULL,
  ylims = NULL,
  label_y1 = NULL,
  label_y2 = add_factor,
  line_col = "black",
  line_size = 1,
  line_type = "solid",
  line_col2 = "black",
  line_size2 = 1,
  line_type2 = "dashed",
  label_x = "time"
)

\method{coef}{GrowthPrediction}(object, ...)
}
\arguments{
\item{x}{The object of class \code{GrowthPrediction} to plot.}

\item{...}{ignored}

\item{object}{an instance of \link{GrowthPrediction}}

\item{y}{ignored}

\item{add_factor}{whether to plot also one environmental factor.
If \code{NULL} (default), no environmental factor is plotted. If set
to one character string that matches one entry of x$env_conditions,
that condition is plotted in the secondary axis. Ignored for \code{environment="constant"}.}

\item{ylims}{A two dimensional vector with the limits of the primary y-axis.}

\item{label_y1}{Label of the primary y-axis.}

\item{label_y2}{Label of the secondary y-axis.}

\item{line_col}{Aesthetic parameter to change the colour of the line geom in the plot, see: \code{\link[ggplot2:geom_path]{ggplot2::geom_line()}}}

\item{line_size}{Aesthetic parameter to change the thickness of the line geom in the plot, see: \code{\link[ggplot2:geom_path]{ggplot2::geom_line()}}}

\item{line_type}{Aesthetic parameter to change the type of the line geom in the plot, takes numbers (1-6) or strings ("solid") see: \code{\link[ggplot2:geom_path]{ggplot2::geom_line()}}}

\item{line_col2}{Same as lin_col, but for the environmental factor.}

\item{line_size2}{Same as line_size, but for the environmental factor.}

\item{line_type2}{Same as lin_type, but for the environmental factor.}

\item{label_x}{Label of the x-axis.}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

The \code{GrowthPrediction} class contains the results of a growth prediction.
Its constructor is \code{\link[=predict_growth]{predict_growth()}}.

It is a subclass of list with the items:
\itemize{
\item simulation: a tibble with the model simulation
\item primary model: a list describing the primary model as in \code{\link[=predict_growth]{predict_growth()}}
\item environment: a character describing the type of environmental conditions
as in \code{\link[=predict_growth]{predict_growth()}}
\item env_conditions: a named list with the functions used to approximate the (dynamic)
environmental conditions. \code{NULL} if \code{environment="constant"}.
\item sec_models: a named list describing the secondary models as in \code{\link[=predict_growth]{predict_growth()}}.
\code{NULL} if \code{environment="constant"}.
\item gammas: a tibble describing the variation of the gamma factors through the experiment.
\code{NUll} if \code{environment="constant"}.
\item logbase_mu: the log-base for the definition of parameter mu (see the relevant vignette)
\item logbase_logN: the log-base for the definition of the logarithm of the population size
}
}
\section{Methods (by generic)}{
\itemize{
\item \code{print(GrowthPrediction)}: print of the model

\item \code{summary(GrowthPrediction)}: summary of the model

\item \code{plot(GrowthPrediction)}: predicted growth curve.

\item \code{coef(GrowthPrediction)}: coefficients of the model

}}
