% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getAttributes.R
\name{getAttributes}
\alias{getAttributes}
\title{Retrieve All Available Attributes for a Specific Dataset}
\usage{
getAttributes(mart, dataset)
}
\arguments{
\item{mart}{a character string specifying the database (mart) for which datasets shall be listed.}

\item{dataset}{a character string specifying the dataset for which attributes shall be listed.}
}
\description{
This funcion queries the BioMart Interface and returns a table
storing all available attributes for a specific dataset.
}
\examples{

\dontrun{

# search for available datasets
getMarts()

# choose database (mart): ENSEMBL_MART_ENSEMBL
# and get a table of all available datasets from this BioMart database
head(getDatasets(mart = "ENSEMBL_MART_ENSEMBL"), 10)

# choose dataset: "hsapiens_gene_ensembl"
head(getAttributes(mart = "ENSEMBL_MART_ENSEMBL", dataset = "hsapiens_gene_ensembl") , 5)

}

}
\seealso{
\code{\link{getMarts}}, \code{\link{getDatasets}}, \code{\link{getFilters}}, \code{\link{organismBM}}, \code{\link{organismFilters}}, \code{\link{organismAttributes}}
}
\author{
Hajk-Georg Drost
}
