% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getENSEMBL.gtf.R
\name{getENSEMBL.gtf}
\alias{getENSEMBL.gtf}
\title{Helper function for retrieving gff files from ENSEMBL}
\usage{
getENSEMBL.gtf(
  organism,
  type = "dna",
  id.type = "toplevel",
  path,
  release = NULL
)
}
\arguments{
\item{organism}{scientific name of the organism of interest.}

\item{type}{biological sequence type.}

\item{id.type}{a character, default "toplevel". id type of assembly, either toplevel or primary_assembly usually.}

\item{path}{location where file shall be stored.}

\item{release}{a numeric, the database release version of ENSEMBL (\code{db = "ensembl"}). Default is \code{release = NULL} meaning
that the most recent database version is used. \code{release = 75} would for human would give the stable
GRCh37 release in ensembl. Value must be > 46, since ensembl did not structure their data
if the standard format before that.}
}
\value{
character filepath to download file, returns FALSE if failed.
}
\description{
This function downloads gff
files of query organisms from ENSEMBL.
}
\author{
Hajk-Georg Drost
}
