#' Droplets containing microbeads
#'
#' The image displays a water-oil emulsion with droplets observed through
#' brightfield microscopy. It is formatted as 'cimg' and sized at 151 × 112
#' pixels. The droplets vary in size, and some contain microbeads, which adds
#' complexity. Brightfield microscopy enhances the contrast between water and
#' oil, revealing the droplet arrangement.
#'
#' @format
#' The image was imported using imager and is therefore of class:
#' "cimg" "imager_array" "numeric"
#' @details
#' Dimensions: width - 151; height - 112; depth - 1; channel - 1
#' @references The image was provided by Coline Kieffer.
#' @examples
#' data(droplets)
#' plot(droplets)
"droplets"
