% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/similarity_dissimilarity_conversion.R
\name{similarity_to_dissimilarity}
\alias{similarity_to_dissimilarity}
\title{Convert similarity metrics to dissimilarity metrics}
\usage{
similarity_to_dissimilarity(similarity, include_formula = TRUE)
}
\arguments{
\item{similarity}{The output object from \code{\link[=similarity]{similarity()}} or
\code{\link[=dissimilarity_to_similarity]{dissimilarity_to_similarity()}}.}

\item{include_formula}{A \code{boolean} indicating whether metrics based on custom
formula(s) should also be converted (see Details). The default is \code{TRUE}.}
}
\value{
A \code{data.frame} with additional class
\code{bioregion.pairwise.metric}, providing dissimilarity
metric(s) between each pair of sites based on a similarity object.
}
\description{
This function converts a \code{data.frame} of similarity metrics between sites
into dissimilarity metrics (beta diversity).
}
\note{
The behavior of this function changes depending on column names. Columns
\code{Site1} and \code{Site2} are copied identically. If there are columns called
\code{a}, \code{b}, \code{c}, \code{A}, \code{B}, \code{C} they will also be copied identically. If there
are columns based on your own formula (argument \code{formula} in \code{\link[=similarity]{similarity()}})
or not in the original list of similarity metrics (argument \code{metrics} in
\code{\link[=similarity]{similarity()}}) and if the argument \code{include_formula} is set to \code{FALSE},
they will also be copied identically. Otherwise there are going to be
converted like they other columns (default behavior).

If a column is called \code{Euclidean}, its distance will be calculated based
on the following formula:

Euclidean distance = (1 - Euclidean similarity) / Euclidean similarity

Otherwise, all other columns will be transformed into dissimilarity with the
following formula:

dissimilarity = 1 - similarity
}
\examples{
comat <- matrix(sample(0:1000, size = 50, replace = TRUE,
prob = 1 / 1:1001), 5, 10)
rownames(comat) <- paste0("Site", 1:5)
colnames(comat) <- paste0("Species", 1:10)

simil <- similarity(comat, metric = "all")
simil

dissimilarity <- similarity_to_dissimilarity(simil)
dissimilarity

}
\seealso{
For more details illustrated with a practical example,
see the vignette:
\url{https://biorgeo.github.io/bioregion/articles/a3_pairwise_metrics.html}.

Associated functions:
\link{dissimilarity} \link{similarity_to_dissimilarity}
}
\author{
Maxime Lenormand (\email{maxime.lenormand@inrae.fr}) \cr
Boris Leroy (\email{leroy.boris@gmail.com}) \cr
Pierre Denelle (\email{pierre.denelle@gmail.com})
}
