% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MDS.R
\name{PCO}
\alias{PCO}
\title{Principal Coordinate Analysis (PCO) biplot method}
\usage{
PCO(bp, Dmat=NULL, dist.func=NULL, dist.func.cat=NULL,
           dim.biplot = c(2,1,3), e.vects = NULL, group.aes=NULL,
           show.class.means = FALSE, axes = c("regression","splines"), ...)
}
\arguments{
\item{bp}{an object of class \code{biplot} obtained from preceding function \code{biplot()}.}

\item{Dmat}{nxn matrix of Euclidean embeddable distances between samples}

\item{dist.func}{function to compute Euclidean embeddable distances between samples. The
default NULL computes Euclidean distance.}

\item{dist.func.cat}{function to compute Euclidean embeddable distance between categorical
variables for the samples. The default NULL computes the extended
matching coefficient.}

\item{dim.biplot}{dimension of the biplot. Only values 1, 2 and 3 are accepted, with default \code{2}.}

\item{e.vects}{e.vects which eigenvectors (canonical variates) to extract, with default \code{1:dim.biplot}.}

\item{group.aes}{vector of the same length as the number of rows in the data matrix
for differentiated aesthetics for samples.}

\item{show.class.means}{logical, indicating whether to plot the class means on the biplot.}

\item{axes}{type of biplot axes, currently only regression axes are implemented}

\item{...}{more arguments to \code{dist.func}}
}
\value{
Object of class biplot
}
\description{
Principal Coordinate Analysis (PCO) biplot method
}
\examples{
biplot(iris[,1:4]) |> PCO(dist.func = sqrtManhattan)
# create a CVA biplot
biplot(iris[,1:4]) |> PCO(dist.func = sqrtManhattan) |> plot()
}
